/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AnalogMuxParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.RampControlParameter;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo4;

public class LinkerToLogo5
extends LinkerToLogo4 {
    public LinkerToLogo5(Hardware hw) {
        super(hw);
    }

    protected void writeWordOrReference(IntegerOrBlockReference integerReference) {
        if (integerReference.isReference()) {
            this.fMemory.putWord(this.convertToPrgLine(integerReference.getReferenceToBlock().getNumber()));
        } else {
            this.fMemory.putWord(integerReference.getValue());
        }
    }

    public Object visit(AnalogMuxParameter param) {
        this.writeWordOrReference(param.getP1Properties());
        this.writeWordOrReference(param.getP2Properties());
        this.writeWordOrReference(param.getP3Properties());
        this.writeWordOrReference(param.getP4Properties());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(255);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(RampControlParameter param) {
        this.writeWordOrReference(param.getRamp1());
        this.writeWordOrReference(param.getRamp2());
        this.fMemory.putWord(param.getMaxOutput().getCurrentValue());
        this.fMemory.putWord(param.getStartStopOffset().getCurrentValue());
        this.fMemory.putWord(param.getRate().getCurrentValue());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(255);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(PIDParameter param) {
        this.writeWordOrReference(param.getSetpoint());
        this.writeWordOrReference(param.getManualOutput());
        this.fMemory.putWord((int)Math.round(param.getLoopGainProperties().getCurrentValue() * 100.0));
        this.writeTimerOrReference(param.getIntegralTime());
        this.fMemory.putWord(param.getMinPV());
        this.fMemory.putWord(param.getMaxPV());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDirection().charValue());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(255);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }
}

